//+------------------------------------------------------------------+
//|                                                     BBMFI_v2.mq4 |
//|                                          Copyright 2014, Yuritch |
//|                                              http://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 2014, MetaQuotes Software Corp."
#property link      "http://www.mql5.com"
#property version   "2.00"
#property strict
#property indicator_chart_window
#property indicator_minimum -1.1
#property indicator_maximum  1.1
#property indicator_level1    0
#property indicator_buffers 1
#property indicator_plots   0
#property indicator_color1  clrNONE

extern int     main_tf     =  1440;    //    
extern int 		main_per		=	1;
extern int		check_tf		=  240;			//   
extern int 		check_per   =	2;

extern int		bar 			= 	0; 		//    

//--- indicator buffers
double         signal[];
double         confirm[];
double         HitfBuffer[];
double         LowtfBuffer[];
int            main_smooth,check_smooth;
int            mtrigger=0, strigger=0;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit()
  {
   IndicatorBuffers(4);

//--- indicator buffers mapping
   SetIndexBuffer(0,signal);
   SetIndexBuffer(1,confirm);
   SetIndexBuffer(2,HitfBuffer);
   SetIndexBuffer(3,LowtfBuffer);
   main_smooth=main_tf/Period();
   check_smooth=check_tf/Period();

   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//---
   if(check_tf==0) check_tf=(int)GlobalVariableGet("bb__");
    
   if(check_tf<Period()) check_tf=Period();
   if(main_tf==0) main_tf = main_period(check_tf);
   
   int counted_bars=IndicatorCounted();
   if(counted_bars>0) counted_bars--;
   int limit=Bars-counted_bars;

   for(int i=0; i<limit; i++)
   {
      HitfBuffer[i]  = iMFI(NULL,main_tf,main_per,iBarShift(NULL,main_tf,Time[i],false));
      LowtfBuffer[i] = iMFI(NULL,check_tf,check_per,iBarShift(NULL,check_tf,Time[i],false));
   }

 for(int i=300; i>=0; i--)   
   {
      signal[i]=signal[i+1];
		if(HitfBuffer[i]>HitfBuffer[i+1]) signal[i]= 1; 
		if(HitfBuffer[i]<HitfBuffer[i+1]) signal[i]=-1;  
      if(LowtfBuffer[i]>LowtfBuffer[i+1]) 	confirm[i]= 1;
     	if(LowtfBuffer[i]<LowtfBuffer[i+1]) 	confirm[i]=-1;
     	if(LowtfBuffer[i]==0 || LowtfBuffer[i]==100 || LowtfBuffer[i]==LowtfBuffer[i+1]) confirm[i]=0;
   }
   	GlobalVariableSet("bb_trend_"+Symbol(), signal[bar]);
   	GlobalVariableSet("bb_sign_"+Symbol(), confirm[bar]); 
  
//--- return value of prev_calculated for next call
   return(rates_total);
  }
  
//+------------------------------------------------------------------+
int main_period(int per)
{
   int tf=0;
   switch(per) {
      case   43200:  tf= 0;     break;
      case   10080:  tf= 43200; break;
      case   1440:   tf= 10080; break; 
      case   240:    tf= 1440;  break;
      case   60:     tf= 240;   break;
      case   30:     tf= 60;    break;
      case   15:     tf= 30;    break;
      case   5:      tf= 15;    break;
      case   1:      tf= 5;     break;
      default:       tf=0;      break;
    }
   return(tf); 
}
