//+------------------------------------------------------------------+
//|                                                 Portfolio_v5.mq4 |
//|                        Copyright 2014, MetaQuotes Software Corp. |
//|                                              http://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 2014, MetaQuotes Software Corp."
#property link      "http://www.mql5.com"
#property version   "5.00"
#property strict
#property indicator_separate_window
#property indicator_buffers 5
#property indicator_color1 clrLime
#property indicator_color2 clrRed
#property indicator_color3 clrSilver
#property indicator_color4 clrRed
#property indicator_color5 clrLime

#property indicator_width1 2
#property indicator_width2 2
#property indicator_width3 2
#property indicator_width4 1
#property indicator_width5 1

#property indicator_level1 0

extern bool     Monthly  =false;                //  
extern bool     Weekly   =false;                //  
extern bool     Daily    =false;                //  
extern int      smooth   = 0;

string Pairs[14],shortname;
int basket=0,digits;
datetime StartTime,Time_Open;
static int StartPos,StopPos=0;
double fibo_array[10]={0,0.236,0.382,0.5,0.618,0.764,1,1.618,2.618,4.236};
string zero_point;
int level_count=7;
bool first_run=true;   
double sum;
int subwin;

//--- buffers
double Up[]; // >0 
double Dn[]; // >0 
double Max[]; // 
double Min[]; // 
double Line[]; //  
int max;
int min;
int time_max;
int time_min;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit()
  {
//--- indicator buffers mapping
   SetIndexStyle(0,DRAW_HISTOGRAM);
   SetIndexBuffer(0,Up);
   SetIndexLabel(0,NULL);
   SetIndexEmptyValue(0,0.0);
   
   SetIndexStyle(1,DRAW_HISTOGRAM);
   SetIndexBuffer(1,Dn);
   SetIndexLabel(1,NULL);
   SetIndexEmptyValue(1,0.0);
     
   SetIndexStyle(2,DRAW_LINE);
   SetIndexBuffer(2,Line);
   SetIndexLabel(2,"Portfolio");
   SetIndexEmptyValue(2,0.0);
      
   SetIndexStyle(3,DRAW_ARROW);
   SetIndexBuffer(3,Max);
   SetIndexArrow(3,0x6C);
   SetIndexLabel(3,NULL);
   SetIndexEmptyValue(3,0.0);

   SetIndexStyle(4,DRAW_ARROW);
   SetIndexBuffer(4,Min);
   SetIndexArrow(4,0x6C);
   SetIndexLabel(4,NULL);
   SetIndexEmptyValue(4,0.0);
   
   IndicatorDigits(2);
   first_run=true;
   Time_Open=TimeCurrent();
//---
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+
void OnDeinit(const int reason) {
     ObjectsDeleteAll(subwin,OBJ_FIBO);
}
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
  
   if (GlobalVariableCheck("bb_period_ma") && smooth==0) smooth=(int)GlobalVariableGet("bb_period_ma");  
   
   int pairs=FileOpen("bbpairs", FILE_TXT|FILE_READ);
   if (pairs>0)
      {
      basket=FileReadArray(pairs,Pairs,0,ArraySize(Pairs));
      FileClose(pairs);
      }
   ArrayResize(Pairs,basket);  
   shortname=StringConcatenate("Portfolio_v5(",smooth,")");
   IndicatorShortName(shortname);   
   subwin=WindowFind(shortname);  
//---
   int i, pos,begin=0;
   
	if(Time_Open!=(int)GlobalVariableGet("bb_zero_point")) reinit();   
	if(begin!=NewZP()) {
		reinit();
		begin=NewZP();
	}
	SetIndexDrawBegin(0, begin); 
	SetIndexDrawBegin(1, begin); 
	SetIndexDrawBegin(2, begin); 	

   for(pos=begin;pos>=0;pos--) {
      sum=0;
		for (i=0;i<basket;i++) {   
      	sum+=deviation(Pairs[i],StartPos,pos);
      }
		if (sum>0) {
      	Line[pos] = sum;
         if (sum>=Max[max]) {
         	ArrayInitialize(Max,0.0);
            max=pos;
            Max[pos]=sum; 
            time_max=(int)Time[pos];
         }
			if (Line[pos]>=Line[pos+1]) Up[pos]=sum;
         else  {Dn[pos]=sum; Up[pos]=0;}
		}

		if (sum<0) {
      	Line[pos] = sum;
         if (sum<=Min[min]) {
         	ArrayInitialize(Min,0.0);
            min=pos;
            Min[pos]=sum; 
            time_min=(int)Time[pos];
			}
         if (Line[pos]<=Line[pos+1]) Dn[pos]=sum;
         else  {Up[pos]=sum; Dn[pos]=0;}
      }
	}
   
	ObjectCreate(0,"PBBstart",OBJ_VLINE, subwin , StartTime,0);
	ObjectSet("PBBstart",OBJPROP_COLOR,DeepSkyBlue);
   ObjectSet("PBBstart",OBJPROP_TIME1,StartTime);
   

   if (ObjectFind(0,"PBBAFUp") ==-1) { 
      ObjectCreate(0,"PBBAFUp" , OBJ_FIBO, subwin ,Time[0] ,0,Time[0],0);
   }   
      ObjectSet("PBBAFUp",OBJPROP_BACK, 1);
      ObjectSet("PBBAFUp", OBJPROP_LEVELSTYLE, STYLE_DOT);
		ObjectSet("PBBAFUp", OBJPROP_FIBOLEVELS, level_count);
		ObjectSet("PBBAFUp", OBJPROP_TIME2, TimeCurrent());      
		ObjectSet("PBBAFUp", OBJPROP_PRICE2, 0);		      
   

   if (ObjectFind(0,"PBBAFDn") ==-1) {
      ObjectCreate(0,"PBBAFDn" , OBJ_FIBO, subwin , Time[0],0,Time[0],0);
    }  
      ObjectSet("PBBAFDn",OBJPROP_BACK, 1);
      ObjectSet("PBBAFDn", OBJPROP_LEVELSTYLE, STYLE_DOT);
		ObjectSet("PBBAFDn", OBJPROP_TIME2, TimeCurrent());       
		ObjectSet("PBBAFDn", OBJPROP_PRICE2, 0);   
		ObjectSet("PBBAFDn", OBJPROP_FIBOLEVELS, level_count);      
      
   
	ObjectSet("PBBAFUp", OBJPROP_TIME1, time_max);
	ObjectSet("PBBAFUp", OBJPROP_PRICE1, Max[max]);    
	ObjectSet("PBBAFDn", OBJPROP_TIME1, time_min);         
	ObjectSet("PBBAFDn", OBJPROP_PRICE1, Min[min]);  	

   for(int j=0; j<level_count; j++) {
      ObjectSet("PBBAFUp", OBJPROP_FIRSTLEVEL+j, fibo_array[j]);
      ObjectSetFiboDescription("PBBAFUp", j, DoubleToStr(ObjectGet("PBBAFUp", OBJPROP_FIRSTLEVEL+j)*100,1) + "  %$");
      ObjectSet("PBBAFUp", OBJPROP_LEVELCOLOR, Gray);
   }

   for(int j=0; j<level_count; j++) {
      ObjectSet("PBBAFDn", OBJPROP_FIRSTLEVEL+j, fibo_array[j]);
      ObjectSetFiboDescription("PBBAFDn", j, DoubleToStr(ObjectGet("PBBAFDn", OBJPROP_FIRSTLEVEL+j)*100,1) + "  %$");
      ObjectSet("PBBAFDn", OBJPROP_LEVELCOLOR, Gray);
   }   
//--- return value of prev_calculated for next call

   return(rates_total);
  }
//+------------------------------------------------------------------+
double deviation(string lSymbol, int Start, int Stop) {
   double Res=0;
   double points=SymbolInfoDouble(lSymbol,SYMBOL_POINT);
   Res=(iMA(lSymbol,0,smooth,0,0,0,Stop)-iMA(lSymbol,0,smooth,0,0,0,Start))/points;
return(Res);
}

//+------------------------------------------------------------------+
int NewZP() {
   zero_point="From EA";
	
	if (!Monthly && !Weekly && !Daily) {
     	Time_Open=(int)GlobalVariableGet("bb_zero_point");
   }
   else {   
		if (Monthly) {Time_Open=iTime(Symbol(), PERIOD_MN1, 1); Weekly=false; Daily=false; zero_point="Monthly";}
		if (Weekly)  {Time_Open=iTime(Symbol(), PERIOD_W1, 1); Daily=false; zero_point="Weekly";}
		if (Daily)   {Time_Open=iTime(Symbol(), PERIOD_D1,  1); zero_point="Daily";}
	}

	if(StartTime!=Time_Open) StartTime=Time_Open;
	StartPos=iBarShift(Symbol(),0, StartTime,0);
	first_run=false;	
return(StartPos);
}
//+------------------------------------------------------------------+
int reinit(){
		Time_Open=TimeCurrent();
		StartPos=0;
		StopPos=0;
		StartTime=Time_Open;

		ArrayInitialize(Up,0.0);
		ArrayInitialize(Dn,0.0);
		ArrayInitialize(Line,0.0);
		ArrayInitialize(Max,0.0);
		ArrayInitialize(Min,0.0);
		return(0);
}